/*
(c) Copyright ROBO Design 2006
http://www.robodesign.ro
*/

// this is the object with all feed-related stuff
// this loads the feed, this shows the feed, etc
function feedObj (url, config)
{
	var _me = this;
	_me.url = url;
	_me.config = config;
	if(!_me.config)
		_me.config = false;

	if(_me.config['minimize'])
		_me.minimize = true;
	else
		_me.minimize = false;

	// this should be the container of all feeds
	_me.container = document.getElementById('feeds');
	if(!_me.container)
		return false;

	// this is what does all the trick :)
	// this function is called when the feed is loaded
	_me.feedLoaded = function ()
	{
		// check if done
		if(_me.xhr.readyState != 4)
			return false;

		// check if there ain't any problems
		if(_me.xhr.status >= 300)
		{
			_me.showMessage(messages['error-status']);
			return false;
		}

		// this is the parsed document of the feed
		_me.feedDoc = _me.xhr.responseXML;
		if(!_me.feedDoc.documentElement)
		{
			_me.showMessage(messages['error-document']);
			return false;
		}

		// try to determine if this is RSS or Atom
		_me.feedType = _me.feedDoc.documentElement.nodeName;
		if(!_me.feedType)
		{
			_me.showMessage(messages['error-document']);
			return false;
		}

		_me.feedType = _me.feedType.toLowerCase();
		if(_me.feedType != 'rss' && _me.feedType != 'feed')
		{
			_me.showMessage(messages['error-format']);
			return false;
		}

		// keep it simple, keep them separated :)
		// this gets all feed entries and feed info into a single multi-dimensional array
		if(_me.feedType == 'rss')
			_me.feedParsed = _me.RSSparser();
		else
			_me.feedParsed = _me.atomParser();

		// if the returned value is a string, then we consider this an error with an associated error message
		if(typeof(_me.feedParsed) == 'string')
		{
			_me.showMessage(messages[_me.feedParsed]);
			return false;
		}

		// if this is false... we consider this is a general parser error
		if(!_me.feedParsed)
		{
			_me.showMessage(messages['error-parser-general']);
			return false;
		}

		// talking about code separation ...
		if(_me.feedType == 'rss')
			_me.showRSS();
		else
			_me.showAtom();
	}

	// eliminate any HTML code from the <description> of RSS feeds
	// this is a "hack" so close your eyes and imagine something beautiful
	// i am using innerHTML then textContent. why? any HTML stripper I'd make wouldn't be as good as Opera's own parser
	_me.rssStripHTML = function (str)
	{
		var elem = document.createElement('div');
		elem.innerHTML = str;

		return elem.textContent;
	}

	// this parses the RSS feeds and returns a multi-dimensional array
	_me.RSSparser = function ()
	{

		var channel = _me.feedDoc.getElementsByTagName('channel')[0];
		if(!channel)
			return false;

		var nodeName, res = [], i, nodes = channel.childNodes.length, node;

		// get feed info
		for(i=0; i<nodes; i++)
		{
			node = channel.childNodes.item(i);
			if(!node.nodeName || node.nodeType != 1)
				continue;

			nodeName = node.nodeName.toLowerCase();
			if(nodeName != 'title' && nodeName != 'link' && nodeName != 'pubdate' && nodeName != 'description' && nodeName != 'lastbuilddate' && nodeName != 'webmaster' && nodeName != 'generator' && nodeName != 'copyright' && nodeName != 'managingeditor' && nodeName != 'image')
				continue;

			// eliminate any sucky HTML in <description>
			if(nodeName == 'description')
			{
				res[nodeName] = _me.rssStripHTML(node.textContent);
				continue;
			}

			// for all non-image nodes
			if(nodeName != 'image')
			{
				res[nodeName] = node.textContent;
				continue;
			}

			// do the image related work
			var url = node.getElementsByTagName('url')[0],
				title = node.getElementsByTagName('title')[0],
				link = node.getElementsByTagName('link')[0],
				description = node.getElementsByTagName('description')[0];

			if(!url || !link)
				continue;

			res['image'] = [];
			res['image']['url'] = url;
			res['image']['link'] = link;
			if(title)
				res['image']['title'] = title;
			if(description)
				res['image']['description'] = description;
		}

		// get entries
		res['entries'] = [];

		var item_nodes = channel.getElementsByTagName('item'), y = 0;
		var items = item_nodes.length, item;
		if(!items || items < 1)
			return 'error-parser-noentry';

		// i don't like loops :)
		for(i=0; i<items; i++)
		{
			item = item_nodes[i];

			nodes = item.childNodes.length;
			if(!nodes || nodes < 1)
				continue;

			res['entries'][i] = [];
			for(y=0; y<nodes; y++)
			{
				node = item.childNodes.item(y);
				nodeName = node.nodeName.toLowerCase();
				if(nodeName != 'title' && nodeName != 'link' && nodeName != 'description' && nodeName != 'pubdate' && nodeName != 'enclosure')
					continue;

				if(nodeName == 'description')
				{
					res['entries'][i][nodeName] = _me.rssStripHTML(node.textContent);
					continue;
				}

				// this is for all non-enclosure stuff
				if(nodeName != 'enclosure')
				{
					res['entries'][i][nodeName] = node.textContent;
					continue;
				}

				// lets get on with the enclosures fun :)
				var url = node.getAttribute('url'), type = node.getAttribute('type'), size = node.getAttribute('length');
				if(!url)
					continue;

				if(!res['entries'][i]['enclosures'])
					res['entries'][i]['enclosures'] = [];

				var z = res['entries'][i]['enclosures'].length;

				res['entries'][i]['enclosures'][z] = [];
				res['entries'][i]['enclosures'][z]['url'] = url;
				if(type)
					res['entries'][i]['enclosures'][z]['type'] = type;
				if(size)
					res['entries'][i]['enclosures'][z]['size'] = size;
			}
		}

		// fun done
		return res;
	}


	// this function 'parses' the RSS date into a displayable format: ISO date
	_me.rssDate = function (str)
	{
		if(!str)
			return false;

		var arr = str.split(' '),
			monthsMap = {
				'jan' : '01',
				'feb' : '02',
				'mar' : '03',
				'apr' : '04',
				'may' : '05',
				'jun' : '06',
				'jul' : '07',
				'aug' : '08',
				'sep' : '09',
				'oct' : '10',
				'nov' : '11',
				'dec' : '12'};

		if(arr.length < 4)
			return str;

		// strip seconds
		if(arr[4].length == 8)
			arr[4] = arr[4].substr(0, 5);

		// lowercase the month name
		arr[2] = arr[2].toLowerCase();

		var year = arr[3],
			month = monthsMap[arr[2]],
			day = arr[1],
			time = arr[4];

		if(!year || !month || !day || !time)
			return str;

		if(year.length != 4 || day.length > 2 || time.length != 5)
			return str;

		if(day.length == 1)
			day = '0' + day;

		return year + '-' + month + '-' + day + ' ' + time;
	}

	// this takes the _me.feedParsed array and displays it
	// only for RSS
	_me.showRSS = function ()
	{
		if(!_me.feedParsed || !_me.feedParsed['entries'])
		{
			_me.showMessage(messages['error-shownofeed']);
			return false;
		}

		// update the feed title and the feed link
		_me.showFeed(_me.feedParsed['title'], _me.feedParsed['link']);

		if(_me.feedParsed['description'])
			_me.feedElem.firstChild.title = _me.feedParsed['description'];

		// now list the feeds
		_me.entriesListElem = document.createElement('ul')
		var i, entry, etitle, eanchor, li, edesc, edate, nr = 0;
		for(i in _me.feedParsed['entries'])
		{
			if(nr > rSettings['max-entries'])
				break;

			entry = _me.feedParsed['entries'][i];
			if(!entry['title'])
				entry['title'] = messages['entry-untitled'];

			li = document.createElement('li');
			eanchor = document.createElement('a');
			etitle = document.createTextNode(entry['title']);

			if(entry['link'])
				eanchor.href = entry['link'];
			else
				eanchor.href = '#';

			eanchor.appendChild(etitle);
			li.appendChild(eanchor);

			if(entry['pubdate'])
			{
				edate = document.createElement('div');
				edate.className = 'feedDate';
				edate.appendChild(document.createTextNode(_me.rssDate(entry['pubdate'])));
				li.appendChild(edate);
			}

			if(entry['description'])
			{
				edesc = document.createElement('p');
				edesc.appendChild(document.createTextNode(entry['description'].substr(0, rSettings['summary-length'])));
				li.appendChild(edesc);
			}

			_me.entriesListElem.appendChild(li);

			nr++;
		}

		_me.feedElem.appendChild(_me.entriesListElem);

		// everything done, don't keep the user waiting anymore
		_me.container.appendChild(_me.feedElem);
	}

	// this returns a nice array for each atomPersonConstruct
	_me.atomPersonConstruct = function (node)
	{
		var tags = ['name', 'uri', 'email'], elem, i, res = [];

		for(i in tags)
		{
			elem = node.getElementsByTagName(tags[i])[0];
			if(elem)
				res[tags[i]] = elem.textContent;
		}

		return res;
	}

	// this returns a nice array for each atom:link
	_me.atomLink = function (node)
	{
		var attrs = ['href', 'rel', 'type', 'hreflang', 'title', 'length'], attr, i, res = [];

		for(i in attrs)
		{
			attr = node.getAttribute(attrs[i]);
			if(attr)
				res[attrs[i]] = attr;
		}

		return res;
	}

	// this function returns the text of an atomTextConstruct
	_me.atomTextConstruct = function (node)
	{
		return node.textContent;
	}

	// this function gets the content of an atomContent
	_me.atomContent = function (node)
	{
		var src = node.getAttribute('src');
		if(!src)
			return node.textContent;

		return src;
	}

	// this parses the Atom feeds and returns a multi-dimensional array
	// same as _parseRSS, but with a different flavour and more complex :)
	_me.atomParser = function ()
	{
		var feed = _me.feedDoc.documentElement;
		if(!feed)
			return false;

		var nodeName, res = [], i, nodes = feed.childNodes.length, node;

		// get feed info
		for(i=0; i<nodes; i++)
		{
			node = feed.childNodes.item(i);
			if(!node.nodeName || node.nodeType != 1)
				continue;

			nodeName = node.nodeName.toLowerCase();

			if(nodeName == 'icon' || nodeName == 'updated' || nodeName == 'logo')
			{
				res[nodeName] = node.textContent;
				continue;
			}

			if(nodeName == 'generator')
			{
				var uri = node.getAttribute('uri'),
					ver = node.getAttribute('version');
				res[nodeName] = [];
				res[nodeName]['content'] = node.textContent;
				if(uri)
					res[nodeName]['uri'] = uri;
				if(ver)
					res[nodeName]['version'] = ver;

				continue;
			}

			if(nodeName == 'contributor' || nodeName == 'author' || nodeName == 'link')
			{
				if(!res[nodeName])
					res[nodeName] = [];

				var z = res[nodeName].length;

				if(nodeName != 'link')
					res[nodeName][z] = _me.atomPersonConstruct(node);
				else
					res[nodeName][z] = _me.atomLink(node);

				continue;
			}

			if(nodeName == 'title' || nodeName == 'subtitle' || nodeName == 'rights')
				res[nodeName] = _me.atomTextConstruct(node);

		}

		// get entries
		res['entries'] = [];

		var item_nodes = feed.getElementsByTagName('entry'), y = 0;
		var items = item_nodes.length, item;
		if(!items || items < 1)
			return 'error-parser-noentry';

		for(i=0; i<items; i++)
		{
			item = item_nodes[i];

			nodes = item.childNodes.length;
			if(!nodes || nodes < 1)
				continue;
			res['entries'][i] = [];
			for(y=0; y<nodes; y++)
			{
				node = item.childNodes.item(y);
				nodeName = node.nodeName.toLowerCase();

				if(nodeName == 'updated' || nodeName == 'published')
				{
					res['entries'][i][nodeName] = node.textContent;
					continue;
				}

				if(nodeName == 'contributor' || nodeName == 'author' || nodeName == 'link')
				{
					if(!res['entries'][i][nodeName])
						res['entries'][i][nodeName] = [];
	
					var z = res['entries'][i][nodeName].length;
	
					if(nodeName != 'link')
						res['entries'][i][nodeName][z] = _me.atomPersonConstruct(node);
					else
						res['entries'][i][nodeName][z] = _me.atomLink(node);

					continue;
				}

				if(nodeName == 'content')
				{
					res['entries'][i][nodeName] = _me.atomContent(node);
					continue;
				}

				if(nodeName == 'title' || nodeName == 'summary' || nodeName == 'rights')
					res['entries'][i][nodeName] = _me.atomTextConstruct(node);
			}
		}

		// fun done
		return res;
	}

	// this function will find the default link for a Atom feed title or Atom entry title
	/* the logic:
		self links suck
		alternate links are good, but those links without any alternate are more likely to be the ones the author wants to be as defaults
		not defining the type is good, means the author considers the default text/html. 
	*/
	_me.atomDefLink = function (link)
	{
		var i, last_score = -100, last_link = false, rel, score = 0, ltype;
		for(i in link)
		{
			score = 0;
			rel = link[i]['rel'];
			if(rel)
				rel = rel.toLowerCase();
			else
				score++;

			if(rel && rel.indexOf('self') == -1)
				score--;

			if(rel && rel.indexOf('alternate') == -1)
				score++;

			ltype = link[i]['type'];
			if(ltype)
				ltype = ltype.toLowerCase();
			else
				score++;

			if(ltype && (ltype == 'text/html' || ltype == 'application/xhtml+xml'))
				score++;

			if(score > last_score)
			{
				last_score = score;
				last_link = i;
			}
		}

		return last_link;
	}

	// this function turns the Atom date into a displayable ISO date format
	_me.atomDate = function (str)
	{
		if(!str || str.length < 16)
			return str;

		str = str.replace('T', ' ');

		return str.substr(0, 16);
		
	}

	// this takes the _me.feedParsed array and displays it
	// only for Atom
	_me.showAtom = function ()
	{
		if(!_me.feedParsed || !_me.feedParsed['entries'])
		{
			_me.showMessage(messages['error-shownofeed']);
			return false;
		}

		var tmp = _me.atomDefLink(_me.feedParsed['link']);

		// update the feed title and link
		_me.showFeed(_me.feedParsed['title'], _me.feedParsed['link'][tmp]['href']);

		if(_me.feedParsed['subtitle'])
			_me.feedElem.firstChild.title = _me.feedParsed['subtitle'];

		// now list the feeds
		_me.entriesListElem = document.createElement('ul')
		var i, entry, etitle, eanchor, li, summary, tmp, edate, nr = 0;
		for(i in _me.feedParsed['entries'])
		{
			if(nr > rSettings['max-entries'])
				break;

			entry = _me.feedParsed['entries'][i];
			if(!entry['title'])
				entry['title'] = messages['entry-untitled'];

			li = document.createElement('li');
			eanchor = document.createElement('a');
			etitle = document.createTextNode(entry['title']);

			if(entry['link'])
			{
				tmp = _me.atomDefLink(entry['link']);
				eanchor.href = entry['link'][tmp]['href'];
				if(entry['link'][tmp]['hreflang'])
					eanchor.setAttribute('hreflang', entry['link'][tmp]['hreflang']);
				if(entry['link'][tmp]['title'])
					eanchor.title = entry['link'][tmp]['title'];
				if(entry['link'][tmp]['type'])
					eanchor.setAttribute('type', entry['link'][tmp]['type']);
			}
			else
				eanchor.href = '#';

			eanchor.appendChild(etitle);
			li.appendChild(eanchor);

			if(entry['updated'])
			{
				edate = document.createElement('div');
				edate.className = 'feedDate';
				edate.appendChild(document.createTextNode(_me.atomDate(entry['updated'])));
				li.appendChild(edate);
			}

			summary = false;

			if(entry['summary'])
				summary = entry['summary'];

			if(!summary && entry['content'])
				summary = entry['content'];

			if(summary)
			{
				tmp = document.createElement('p');
				tmp.appendChild(document.createTextNode(summary.substr(0, rSettings['summary-length'])));
				li.appendChild(tmp);
			}

			_me.entriesListElem.appendChild(li);

			nr++;
		}
		_me.feedElem.appendChild(_me.entriesListElem);

		// everything done, don't keep the user waiting anymore
		_me.container.appendChild(_me.feedElem);

		return true;
	}

	_me.showFeed = function (title, link)
	{
		if(title)
		{
			_me.feedElem.firstChild.firstChild.removeChild(_me.feedElem.firstChild.firstChild.firstChild);
			_me.feedElem.firstChild.firstChild.appendChild(document.createTextNode(title));
		}

		if(link)
			_me.feedElem.firstChild.firstChild.href = link;

		// eliminate the "loading" message
		_me.feedElem.removeChild(_me.feedElem.lastChild);

		if(_me.minimize)
			_me.feedElem.className = 'feed feedMinimized';
		else
			_me.feedElem.className = 'feed';

		// add the minimize button
		var minstate = _me.minimize ? '+' : '-';
		_me.minElem = document.createElement('div');
		_me.minElem.className = 'buttonFeedMinimize';
		_me.minElem.title = messages['button-feedminimize'];
		_me.minElem.addEventListener('click', _me.minimizeFeed, false);
		_me.minElem.appendChild(document.createTextNode(minstate));
		_me.feedElem.appendChild(_me.minElem);

		saveFeeds();

		return true;
	}

	// this displays any error messages in the feed
	_me.showMessage = function (msg)
	{
		_me.feedElem.removeChild(_me.feedElem.lastChild);
		tmp = document.createElement('p');
		tmp.appendChild(document.createTextNode(msg));
		_me.feedElem.appendChild(tmp);

		return true;
	}

	// this function deletes the feed
	_me.deleteFeed = function ()
	{
		_me.container.removeChild(_me.feedElem);
		_me.deleted = true;
		saveFeeds();
	}

	_me.minimizeFeed = function ()
	{
		var newmin = _me.minimize ? false : true;
		var minstate = newmin ? '+' : '-';

		_me.minElem.removeChild(_me.minElem.firstChild);
		_me.minElem.appendChild(document.createTextNode(minstate));

		if(newmin)
			_me.feedElem.className = 'feed feedMinimized';
		else
			_me.feedElem.className = 'feed';

		_me.minimize = newmin;

		saveFeeds();

		return true;
	}

	// this is where all feed entries *and* title go
	_me.feedElem = document.createElement('div');
	_me.feedElem.className = 'feed feedLoading';

	// insert feed title and link
	feedTitle = document.createElement('h1');
	feedLink = document.createElement('a');

	feedLink.href = url;

	if(!_me.config['title'])
		feedLink.appendChild(document.createTextNode(url));
	else
		feedLink.appendChild(document.createTextNode(_me.config['title']));

	feedTitle.appendChild(feedLink);
	_me.feedElem.appendChild(feedTitle);

	// feed delete button
	feedDelete = document.createElement('div');
	feedDelete.className = 'buttonFeedDelete';
	feedDelete.appendChild(document.createTextNode(messages['button-feeddelete']));
	feedDelete.title = messages['button-feeddelete-title'];
	feedDelete.addEventListener('click', _me.deleteFeed, false);
	_me.feedElem.appendChild(feedDelete);

	feedMsg = document.createElement('p');
	feedMsg.appendChild(document.createTextNode(messages['feed-loading']));
	_me.feedElem.appendChild(feedMsg);

	_me.container.appendChild(_me.feedElem);

	// AJAXians beware! :)
	_me.xhr = new XMLHttpRequest();
	_me.xhr.onreadystatechange = _me.feedLoaded;

	// the question is: to open or not to open?
	_me.xhr.open("GET", _me.url, true);
	_me.xhr.send(null);

	// i love myself :P
	return _me;
}
