/*
(c) Copyright ROBO Design 2006
http://www.robodesign.ro
*/

var feedObjects = [],
	pages = ['page-add', 'page-main', 'page-about'],
	current_page = false,
	rVersion = 1,
	rBuild = 20060415,
	scrollDirection = false,
	scrollInterval = false;

// used for debugging :)
function showObj(obj, prefix)
{
	res = '';

	if(!prefix)
		prefix = '';

	for(i in obj)
	{
		res += prefix + '.' + i + ' = ' + obj[i] + "\n";
		if(typeof(obj[i]) == 'object')
			res += showObj(obj[i], prefix+'.'+i);
	}

	return res;
}

// this is the function used by the Add New Feed button
function addNewFeed ()
{
	flipToPage('page-add');
}

// this is the function called when the user tries to add a new feed
function submitFeed ()
{

	// get the feed URL
	var elem = document.getElementById('value-feedurl');
	if(elem && elem.value && elem.value != 'http://')
		feedObjects[feedObjects.length] = new feedObj(elem.value);

	// show the feeds
	flipToPage('page-main');

	return false;
}

// function which flips from a page to another
function flipToPage(page)
{
	var elem;
	if(current_page && current_page != page)
	{
		elem = document.getElementById(current_page);
		if(elem)
			elem.style.display = 'none';
	}
	elem = document.getElementById(page);
	if(elem)
		elem.style.display = 'block';
	current_page = page;

	var btnup = document.getElementById('scrollup'),
		btndown = document.getElementById('scrolldown'),
		btnreturn = document.getElementById('button-page-return');

	// if this is not the main page: hide scrolls
	if(page != 'page-main')
	{
		btnup.style.display = 'none';
		btndown.style.display = 'none';
		btnreturn.style.display = 'inline';
	} else
	{
		btnup.style.display = 'block';
		btndown.style.display = 'block';
		btnreturn.style.display = 'none';
	}

	return true;
}

// simple :)
function showMain()
{
	flipToPage('page-main');
}

function showAbout()
{
	flipToPage('page-about');
}

// scroll fun
function rScrollStart (e)
{

	if(scrollInterval)
		return false;

	if(e.target.id == 'scrollup')
		scrollDirection = 1;
	else
		scrollDirection = -1;

	scrollInterval = setInterval(rScroll, rSettings['scroll-delay'])
}

function rScroll ()
{
 	if(!scrollInterval)
 		return false;

	if(scrollDirection == -1)
		scrollElem.scrollTop = scrollElem.scrollTop + rSettings['scroll-pixels'];
	else
		scrollElem.scrollTop = scrollElem.scrollTop - rSettings['scroll-pixels'];

	return true;
}

function rScrollStop ()
{
	if(scrollInterval)
	{
		clearInterval(scrollInterval);
		scrollInterval = false;
	}
}

function saveFeeds ()
{
	var i, res = '';
	for(i in feedObjects)
	{
		if(feedObjects[i].deleted)
			continue;

		if(feedObjects[i].minimize)
			res += 1;
		else
			res += 0;
		res += feedObjects[i].url + "\n";
	}

	widget.setPreferenceForKey(res, 'feeds');
	return true;
}

// this is the function executed when the widget is loaded
function widgetLoaded()
{
	// setup the messages and some buttons
	var i, elem, tmp;
	tmp = document.getElementById('prompt-addnewfeed');
	tmp.appendChild(document.createTextNode(messages['prompt-addnewfeed']));

	tmp = document.getElementById('button-submitfeed');
	tmp.addEventListener('click', submitFeed, false);
	tmp.appendChild(document.createTextNode(messages['button-submitfeed']));

	tmp = document.getElementById('form-addnewfeed');
	// "hack" :)
	tmp.setAttribute('onsubmit', 'void(submitFeed());return false');

	tmp = document.getElementById('button-page-return');
	tmp.addEventListener('click', showMain, false);
	tmp.appendChild(document.createTextNode(messages['button-page-return']));

	// setup the pages
	tmp = pages.length;
	for(i=0; i<tmp; i++)
	{
		elem = document.getElementById(pages[i]);
		if(elem)
		{
			elem.className = 'page';
			elem.style.display = 'none';
		}
	}
	flipToPage('page-main');

	tmp = document.getElementById('about-text');
	tmp.appendChild(document.createTextNode('Raggregator '+rVersion+' (build '+rBuild+')'));

	// add the menus
	elem = document.getElementById('menus');
	tmp = document.createElement('li');
	tmp.addEventListener('click', addNewFeed, false);
	tmp.appendChild(document.createTextNode(messages['button-addnewfeed']));
	elem.appendChild(tmp);

	tmp = document.createElement('li');
	tmp.addEventListener('click', showAbout, false);
	tmp.appendChild(document.createTextNode(messages['button-about']));
	elem.appendChild(tmp);

	// setup scroll buttons
	window.scrollElem = document.getElementById('page-main');
	tmp = document.getElementById('scrollup');
	tmp.addEventListener('mouseover', rScrollStart, false);
	tmp.addEventListener('mouseout', rScrollStop, false);

	tmp = document.getElementById('scrolldown');
	tmp.addEventListener('mouseover', rScrollStart, false);
	tmp.addEventListener('mouseout', rScrollStop, false);

	// load the feeds
	var thefeeds = widget.preferenceForKey("feeds");

	// if nothing, use defaults
	if(!thefeeds)
	{
		thefeeds = '';
		for(i in rSettings['default-feeds'])
			thefeeds = thefeeds + '0' + rSettings['default-feeds'][i] + "\n";
	}

	thefeeds = thefeeds.split("\n");
	for(var i in thefeeds)
	{
		if(thefeeds[i].length < 5)
			continue;

		tmp = thefeeds[i].substr(0,1);
		if(tmp == 1)
			tmp = true;
		else
			tmp = false;

		feedObjects[feedObjects.length] = new feedObj(thefeeds[i].substr(1), {'minimize' : tmp});
	}

}

// make the world spin
document.addEventListener('load', widgetLoaded, false);
