#!/usr/bin/php
<?php
/*
Copyright (C) 2006-2007 Mihai Şucan
http://www.robodesign.ro/

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

// last update 2007-07-02
$page = '';
$profile = 'maximum';

while(!feof(STDIN))
	$page .= fgets(STDIN, 4096);

if($page == '')
{
	fwrite(STDERR, "No STDIN!\n");
	return 1;
}

$inputsize = strlen($page);

include(dirname(__FILE__) . '/../src/retidy.php');

class ReTidy_stdio extends ReTidy
{
	protected function logMsg ($msg)
	{
		$msg = parent::logMsg($msg);
		fwrite(STDERR, $msg);

		return $msg;
	}
}

$cleaner = new ReTidy_stdio($profile);

$cleaner->setCode($page);
$res = $cleaner->cleanCode();

echo $cleaner->getCode();

fwrite(STDERR, 'Result: ' . ($res ? 'true' : 'false') . "\n" .
'Run time: ' . round($cleaner->timer_total, 4) . " seconds\n".
"Input size: $inputsize bytes\n".
"Output size: " . strlen($cleaner->getCode()) . " bytes\n".
"Memory usage: " . memory_get_usage() . " bytes\n");

?>
